---
title: Return small HTML page · Cloudflare Workers docs
description: Deliver an HTML page from an HTML string directly inside the Worker script.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python,Rust
source_url:
  html: https://developers.cloudflare.com/workers/examples/return-html/
  md: https://developers.cloudflare.com/workers/examples/return-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/return-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwBGAEzDBI0QA5pYgFwsWbYBzhcafAVIlTZYgLAAoAMLoqEAKYXsAESgBnGOgdRo5+SRV4CxElThgSwYAIigaSwAPADoAKwcQ0lQoMGtA4LCImPiQ4zMLawhsABU6GEtPOBgYMD4CKHNkWLgANzgHXgRYCABqYHRccEtjYyjnJBJcS1Q4cAgSAG8jEhJ2uipeL0sIXgALAAoESwBHEEsHCABKReWVkl5zC5JdiGAwEgYSAAMAHgBCWwAeRMxQAmgAFACiz1eYAAfLcVj8KLg6Ai7ncfrthHCABKWMBgdAkADqmDAuB+yGx6IxJB+MDhxV2jhIwEQAGsQDASAB3dokADm1ksCAIllw5DoqxIJiJIFwqDAiEspMwHNF0SpjMR9OQKLRXyIRl1RwgIAQVH8ll5JAASudnFQHJZ9i83gAaG5056WOBTBAOTxLH0rEIPAo2CBlSwhTwhKyRFDusBEPaIF0QBgAVWKADFsNIQh7dSsAL4ljFly7G8slstEYxKZgqNQaHj8IRiXRifSiPLmKw2exOFxuBpUTzeNSkAJBUJBQhqRJeFJpechMhEsi5UyDwolGOVaq1Xj1RrxcwjIwLELs8IAfX6g1SccyU2yCTLTebrd87a0LtxEkXs5FEZhjCAA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          html = """<!DOCTYPE html>
          <body>
            <h1>Hello World</h1>
            <p>This markup was generated by a Cloudflare Worker.</p>
          </body>"""


          headers = {"content-type": "text/html;charset=UTF-8"}
          return Response(html, headers=headers)
  ```

* Rust

  ```rs
  use worker::*;


  #[event(fetch)]
  async fn fetch(_req: Request, _env: Env, _ctx: Context) -> Result<Response> {
      let html = r#"<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>
      "#;
      Response::from_html(html)
  }
  ```

* Hono

  ```ts
  import { Hono } from "hono";
  import { html } from "hono/html";


  const app = new Hono();


  app.get("*", (c) => {
    const doc = html`<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker with Hono.</p>
      </body>`;


    return c.html(doc);
  });


  export default app;
  ```
